unit sabutils;
{Tbe most important part of of this file was a small part of the XDOM Unit, a file of
the Open XML software written by Dieter Khler. As I only need the URI parsing function
I copy them in a separate file. All the functions contained  in this file are still covered by
the license of Open XML and if he wants Dieter can use any modified version of this file for
Open XML. I consider the Open XML license as Open Source. More infos at http://www.philo.de/openxml
}

interface
{$IFDEF FPC}
 {$MODE DELPHI}
{$ENDIF}


uses SysUtils, Classes;

type


TSabUri=string;

TIniFile = class(TObject)
private
  FFileName: string;
  FContent:TStringList;
public
  constructor Create(const AFileName: string);
  destructor Destroy;override;
  function ReadString(const Section, Ident, Default: string): string;
  procedure WriteString(const Section, Ident, Value: String);
  procedure ReadSectionValues(const Section: string; Strings: TStrings);
  procedure SaveSectionValues(const Section: string; Strings: TStrings);
  procedure EraseSection(const Section: string);
  procedure UpdateFile;
  property FileName: string read FFileName;
end;

  TUriStrAnalyzer = class
  protected
    FUriAuthority: string;
    FUriFragment: string;
    FUriQuery: string;
    FUriPath: string;
    FUriScheme: string;
    FHasUriAuthority: boolean;
    FHasUriFragment: boolean;
    FHasUriQuery: boolean;
    FHasUriScheme: boolean;
    function getUriReference: string; virtual;
  public
    constructor create;
    function setUriAuthority(const Value: string;
                             const isDefined: boolean): boolean; virtual;
    function setUriFragment(const Value: string;
                            const isDefined: boolean): boolean; virtual;
    function setUriPath(const Value: string): boolean; virtual;
    function setUriQuery(const Value: string;
                         const isDefined: boolean): boolean; virtual;
    function setUriReference(const Value: string): boolean; virtual;
    function setUriScheme(const Value: string;
                          const isDefined: boolean): boolean; virtual;
    property HasUriAuthority: boolean read FHasUriAuthority;
    property HasUriFragment: boolean read FHasUriFragment;
    property HasUriQuery: boolean read FHasUriQuery;
    property HasUriScheme: boolean read FHasUriScheme;
    property UriAuthority: string read FUriAuthority;
    property UriFragment: string read FUriFragment;
    property UriPath: string read FUriPath;
    property UriQuery: string read FUriQuery;
    property UriReference: string read getUriReference;
    property UriScheme: string read FUriScheme;
  end;

function isAbnfALPHAChar(c: char): boolean;
function isAbnfBITChar(c: char): boolean;
function isAbnfCHARChar(c: char): boolean;
function isAbnfCRChar(c: char): boolean;
function isAbnfCRLFStr(s: string): boolean;
function isAbnfCTLChar(c: char): boolean;
function isAbnfDIGITChar(c: char): boolean;
function isAbnfDQUOTEChar(c: char): boolean;
function isAbnfHEXDIGChar(c: char): boolean;
function isAbnfHTABChar(c: char): boolean;
function isAbnfLFChar(c: char): boolean;
function isAbnfLWSPStr(s: string): boolean;
function isAbnfOCTETChar(c: char): boolean;
function isAbnfSPChar(c: char): boolean;
function isAbnfVCHARChar(c: char): boolean;
function isAbnfWSPChar(c: char): boolean;

function isUriURI_referenceStr(s: string): boolean;
function isUriAbsoluteURIStr(s: string): boolean;
function isUriRelativeURIStr(s: string): boolean;
function isUriHier_partStr(s: string): boolean;
function isUriOpaque_partStr(s: string): boolean;
function isUriNet_pathStr(s: string): boolean;
function isUriAbs_pathStr(s: string): boolean;
function isUriRel_pathStr(s: string): boolean;
function isUriRel_segmentStr(s: string): boolean;
function isUriSchemeStr(s: string): boolean;
function isUriAuthorityStr(s: string): boolean;
function isUriReg_nameStr(s: string): boolean;
function isUriServerStr(s: string): boolean;
function isUriUserinfoStr(s: string): boolean;
function isUriHostPortStr(s: string): boolean;
function isUriHostStr(s: string): boolean;
function isUriHostnameStr(s: string): boolean;
function isUriDomainlabelStr(s: string): boolean;
function isUriToplabelStr(s: string): boolean;
function isUriIPv4addressStr(s: string): boolean;
function isUriPortStr(s: string): boolean;
function isUriPathStr(s: string): boolean;
function isUriPath_segmentsStr(s: string): boolean;
function isUriSegmentStr(s: string): boolean;
function isUriParamStr(s: string): boolean;
function isUriQueryStr(s: string): boolean;
function isUriFragmentStr(s: string): boolean;
function isUriUricStr(s: string): boolean;
function isUriReservedChar(c: char): boolean;
function isUriUnreservedChar(c: char): boolean;
function isUriMarkChar(c: char): boolean;
function isUriHexChar(c: char): boolean;
function isUriAlphanumChar(c: char): boolean;
function isUriAlphaChar(c: char): boolean;
function isUriDigitChar(c: char): boolean;

// Functions added by Christophe ESPERN for the Sablopas Project


function resolveRelativeUriStr(const baseUri,relUri: string;var resultUri: string): boolean;

function UriStrToFilename(const uri: string;var path: TFilename; var authority,query,fragment: string): boolean;

procedure SplitKeyValue(const s:string;var key,value:string);

function UnixPathToDosPath(const Path: string): string;
function DosPathToUnixPath(const Path: string): string;

function ExtractURIScheme(const URI: string): string;
function ExtractURIRest(const URI: string): string;
function ExtractURIFilename(const URI: string): string;

function PosIdx (Const Substr : AnsiString; Const Source : AnsiString;i:longint) : Longint;
procedure Replace(var s:string;const s1,s2:string);

procedure StringFromFile(const fname:string;var s:string);

implementation

Function PosIdx (Const Substr : AnsiString; Const Source : AnsiString;i:longint) : Longint;
  var
    S : String;
  begin
    PosIdx:=0;
    if Length(SubStr)=0 then
     exit;
    while (i <= length (Source) - length (substr)) do
     begin
       inc (i);
       S:=copy(Source,i,length(Substr));
       if S=SubStr then
       exit;
     end;
end;

procedure Replace(var s:string;const s1,s2:string);
 var
  last,
  x  : longint;
 begin
  last:=0;
  repeat
   x:=posidx(s1,uppercase(s),last);
   if (x>0) then
   begin
     Delete(s,x,length(s1));
     Insert(s2,s,x);
     last:=x+1;
   end;
  until (x=0);
end;

function ExtractURIScheme(const URI: string): string;
begin
 Result:=Copy(uri,0,pos('://',uri)-1);
 if Result='' then Result:=  Copy(uri,0,pos(':/',uri)-1)
end;

function ExtractURIRest(const URI: string): string;
begin
 Result:=Copy(URI,Pos('://',URI)+1,length(URI));
 if Result='' then Result:=Copy(URI,Pos(':/',URI)+1,length(URI));
end;

function ExtractURIFilename(const URI: string): string;
begin
 Result:=Copy(URI,Pos('://',URI)+3,length(URI));
 if Result='' then Result:=Copy(URI,Pos(':/',URI)+2,length(URI));
end;

function isUriURI_referenceStr(s: string): boolean;
var
  dcPos: integer;
  s1: string;
begin
  dcPos:= pos('#',s);
  if dcPos > 0 then begin
    s1:= copy(s,1,dcPos-1);
    result:= (   isUriAbsoluteURIStr(s1)
              or isUriRelativeURIStr(s1)
              or (s1 = '') )
              and isUriFragmentStr(copy(s,dcPos+1,length(s)-dcPos));
  end else
    result:= isUriAbsoluteURIStr(s) or isUriRelativeURIStr(s) or (s = '');
end;

function isUriAbsoluteURIStr(s: string): boolean;
var
  colonPos: integer;
  s1: string;
begin
  colonPos:= pos(':',s);
  if colonPos > 0 then begin
    s1:= copy(s,colonPos+1,length(s)-colonPos);
    result:= isUriSchemeStr(copy(s,1,colonPos-1)) and
             ( isUriHier_partStr(s1) or isUriOpaque_partStr(s1) );
  end else result:= false;
end;

function isUriRelativeURIStr(s: string): boolean;
var
  qmPos: integer;
  s1: string;
begin
  qmPos:= pos('?',s);
  if qmPos > 0 then begin
    s1:= copy(s,1,qmPos-1);
    result:= (   isUriNet_pathStr(s1)
              or isUriAbs_pathStr(s1)
              or isUriRel_pathStr(s1) )
              and isUriQueryStr(copy(s,qmPos+1,length(s)-qmPos));
  end else
    result:= isUriNet_pathStr(s) or isUriAbs_pathStr(s) or isUriRel_pathStr(s);
end;

function isUriHier_partStr(s: string): boolean;
var
  qmPos: integer;
  s1: string;
begin
  qmPos:= pos('?',s);
  if qmPos > 0 then begin
    s1:= copy(s,1,qmPos-1);
    result:= (   isUriNet_pathStr(s1)
              or isUriAbs_pathStr(s1) )
              and isUriQueryStr(copy(s,qmPos+1,length(s)-qmPos));
  end else
    result:= isUriNet_pathStr(s) or isUriAbs_pathStr(s);
end;

function isUriOpaque_partStr(s: string): boolean;
begin
  if s = '' then begin result:= false; exit; end;
  if s[1] = '/' then begin result:= false; exit; end;
  result:= isUriUricStr(s);
end;

function isUriNet_pathStr(s: string): boolean;
var
  slashPos: integer;
begin
  if copy(s,1,2) <> '//' then begin result:= false; exit; end;
  s:= copy(s,3,length(s)-2);
  slashPos:= pos('/',s);
  if slashPos > 0 then begin
    result:= isUriAuthorityStr(copy(s,1,slashPos-1)) and isUriAbs_pathStr(copy(s,slashPos,length(s)-slashPos+1));
  end else
    result:= isUriAuthorityStr(s);
end;

function isUriAbs_pathStr(s: string): boolean;
begin
  if s = '' then begin result:= false; exit; end;
  if s[1] <> '/' then begin result:= false; exit; end;
  result:= isUriPath_segmentsStr(copy(s,2,length(s)-1));
end;

function isUriRel_pathStr(s: string): boolean;
var
  slashPos: integer;
begin
  slashPos:= pos('/',s);
  if slashPos > 0 then begin
    result:= isUriRel_segmentStr(copy(s,1,slashPos-1)) and isUriAbs_pathStr(copy(s,slashPos,length(s)-slashPos+1));
  end else
    result:= isUriRel_segmentStr(s);
end;

function isUriRel_segmentStr(s: string): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  if l = 0 then begin result:= false; exit; end;
  result:= true;
  i:= 0;
  while i < l do begin
    inc(i);
    if s[i] = '%' then begin
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
    end else if not ( isUriUnreservedChar(s[i])
                      or (s[i] = ';') or (s[i] = '@') or (s[i] = '&')
                      or (s[i] = '=') or (s[i] = '+') or (s[i] = '$')
                      or (s[i] = ',') )
      then begin result:= false; exit; end;
  end;
end;

function isUriSchemeStr(s: string): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  if l = 0 then begin result:= false; exit; end;
  if not isAbnfALPHAChar(s[1]) then begin result:= false; exit; end;
  result:= true;
  for i:= 2 to l do
    if not (    isAbnfALPHAChar(s[i])
             or isAbnfDIGITChar(s[i])
             or (s[i] = '+')
             or (s[i] = '-')
             or (s[i] = '.')
           )
      then begin result:= false; exit; end;
end;

function isUriAuthorityStr(s: string): boolean;
begin
  result:= isUriServerStr(s) or isUriReg_nameStr(s);
end;

function isUriReg_nameStr(s: string): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  if l = 0 then begin result:= false; exit; end;
  result:= true;
  i:= 0;
  while i < l do begin
    inc(i);
    if s[i] = '%' then begin
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
    end else if not ( isUriUnreservedChar(s[i])
                      or (s[i] = '$') or (s[i] = ',') or (s[i] = ';')
                      or (s[i] = ':') or (s[i] = '@') or (s[i] = '&')
                      or (s[i] = '=') or (s[i] = '+') )
      then begin result:= false; exit; end;
  end;
end;

function isUriServerStr(s: string): boolean;
var
  atPos,l: integer;
begin
  l:= length(s);
  if l = 0 then begin result:= true; exit; end;
  atPos:= pos('@',s);
  if atPos > 0 then begin
    result:= isUriUserinfoStr(copy(s,1,atPos-1)) and isUriHostportStr(copy(s,atPos+1,l-atPos));
  end else
    result:= isUriHostportStr(s);
end;

function isUriUserinfoStr(s: string): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  result:= true;
  if l = 0 then exit;
  i:= 0;
  while i < l do begin
    inc(i);
    if s[i] = '%' then begin
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
    end else if not ( isUriUnreservedChar(s[i])
                      or (s[i] = ';') or (s[i] = ':') or (s[i] = '&')
                      or (s[i] = '=') or (s[i] = '+') or (s[i] = '$')
                      or (s[i] = ',') )
      then begin result:= false; exit; end;
  end;
end;

function isUriHostPortStr(s: string): boolean;
var
  colonPos: integer;
begin
  colonPos:= pos(':',s);
  if colonPos > 0 then begin
    result:= isUriHostStr(copy(s,1,colonPos-1)) and isUriPortStr(copy(s,colonPos+1,length(s)-colonPos));
  end else
    result:= isUriHostStr(s);
end;

function isUriHostStr(s: string): boolean;
begin
  result:= isUriHostnameStr(s) or isUriIPv4addressStr(s);
end;

function isUriHostnameStr(s: string): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  if l = 0 then begin result:= false; exit; end;
  result:= true;
  if s[l] = '.' then dec(l);
  i:= l;
  while i > 0 do begin
    if s[i] = '.' then break;
    dec(i);
  end;
  if not isUriToplabelStr(copy(s,i+1,l-i))
    then begin result:= false; exit; end;
  while i > 0 do begin
    l:= i;
    if s[l] = '.' then dec(l);
    i:= l;
    while i > 0 do begin
      if s[i] = '.' then break;
      dec(i);
    end;
    if not isUriDomainlabelStr(copy(s,i+1,l-i))
      then begin result:= false; exit; end;
  end;
end;

function isUriDomainlabelStr(s: string): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  if l = 0 then begin result:= false; exit; end;
  if not ( isUriAlphanumChar(s[1]) and isUriAlphanumChar(s[l]) )
    then begin result:= false; exit; end;
  result:= true;
  i:= 1;
  while i < l do begin
    inc(i);
    if not (isUriAlphanumChar(s[i]) or (s[i] = '-') )
       then begin result:= false; exit; end;
  end;
end;

function isUriToplabelStr(s: string): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  if l = 0 then begin result:= false; exit; end;
  if not ( isUriAlphaChar(s[1]) and isUriAlphanumChar(s[l]) )
    then begin result:= false; exit; end;
  result:= true;
  i:= 1;
  while i < l do begin
    inc(i);
    if not (isUriAlphanumChar(s[i]) or (s[i] = '-') )
       then begin result:= false; exit; end;
  end;
end;

function isUriIPv4addressStr(s: string): boolean;
var
  digitNo,colonNo,i,l: integer;
  digitFound: boolean;
begin
  result:= false;
  l:= length(s);
  i:= 0;
  digitNo:= 0;
  colonNo:= 0;
  digitFound:= false;
  while i < l do begin
    if isUriDigitChar(s[i]) then begin
      if not digitFound then begin
        digitFound:= true;
        inc(digitNo);
      end;
    end else if s[i] = '.' then begin
      if not digitFound then exit;
      digitFound:= false;
      inc(colonNo);
    end else exit;
  end;
  if (colonNo = 3) and (digitNo = 4) then result:= true;
end;

function isUriPortStr(s: string): boolean;
var
  i,l: integer;
begin
  result:= true;
  l:= length(s);
  for i:= 1 to l do
    if not isUriDigitChar(s[i]) then begin result:= false; exit; end;
end;

function isUriPathStr(s: string): boolean;
begin
  if isUriAbs_pathStr(s) or isUriOpaque_partStr(s) or (s = '')
    then result:= true
    else result:= false;
end;

function isUriPath_segmentsStr(s: string): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  result:= true;
  if l = 0 then exit;
  i:= 0;
  while i < l do begin
    inc(i);
    if s[i] = '%' then begin
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
    end else if not ( isUriUnreservedChar(s[i])
                      or (s[i] = ':') or (s[i] = '@') or (s[i] = '&')
                      or (s[i] = '=') or (s[i] = '+') or (s[i] = '$')
                      or (s[i] = ',') or (s[i] = ';') or (s[i] = '/') )
      then begin result:= false; exit; end;
  end;
end;

function isUriSegmentStr(s: string): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  result:= true;
  if l = 0 then exit;
  i:= 0;
  while i < l do begin
    inc(i);
    if s[i] = '%' then begin
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
    end else if not ( isUriUnreservedChar(s[i])
                      or (s[i] = ':') or (s[i] = '@') or (s[i] = '&')
                      or (s[i] = '=') or (s[i] = '+') or (s[i] = '$')
                      or (s[i] = ',') or (s[i] = ';') )
      then begin result:= false; exit; end;
  end;
end;

function isUriParamStr(s: string): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  result:= true;
  if l = 0 then exit;
  i:= 0;
  while i < l do begin
    inc(i);
    if s[i] = '%' then begin
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
    end else if not ( isUriUnreservedChar(s[i])
                      or (s[i] = ':') or (s[i] = '@') or (s[i] = '&')
                      or (s[i] = '=') or (s[i] = '+') or (s[i] = '$')
                      or (s[i] = ',') )
      then begin result:= false; exit; end;
  end;
end;

function isUriQueryStr(s: string): boolean;
begin
  if s = ''
    then result:= true
    else result:= isUriUricStr(s);
end;

function isUriFragmentStr(s: string): boolean;
begin
  if s = ''
    then result:= true
    else result:= isUriUricStr(s);
end;

function isUriUricStr(s: string): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  if l = 0
    then begin result:= false; exit; end
    else result:= true;
  i:= 0;
  while i < l do begin
    inc(i);
    if s[i] = '%' then begin
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
    end else if not ( isUriReservedChar(s[i]) or isUriUnreservedChar(s[i]) )
      then begin result:= false; exit; end;
  end;
end;

function isUriReservedChar(c: char): boolean;
begin
  if (c=';') or (c='/') or (c='?') or (c=':') or (c='@') or (c='&') or
     (c='=') or (c='+') or (c='$') or (c=',')
    then result:= true
    else result:= false;
end;

function isUriUnreservedChar(c: char): boolean;
begin
  if isUriAlphanumChar(c) or isUriMarkChar(c)
    then result:= true
    else result:= false;
end;

function isUriMarkChar(c: char): boolean;
begin
  if (c='-') or (c='_') or (c='.') or (c='!') or (c='~') or (c='*') or
     (c=#39) or (c='(') or (c=')')
    then result:= true
    else result:= false;
end;

function isUriHexChar(c: char): boolean;
begin
  case byte(c) of
    $30..$39,$41..$46,$61..$66:  // 0..9 , A..F , a..f
    result:= true;
  else
    result:= false;
  end;
end;

function isUriAlphanumChar(c: char): boolean;
begin
  case byte(c) of
    $30..$39,$41..$5A,$61..$7A:
    result:= true;
  else
    result:= false;
  end;
end;

function isUriAlphaChar(c: char): boolean;
begin
  case byte(c) of
    $41..$5A,$61..$7A:
    result:= true;
  else
    result:= false;
  end;
end;

function isUriDigitChar(c: char): boolean;
begin
  case byte(c) of
    $30..$39:
    result:= true;
  else
    result:= false;
  end;
end;


procedure SplitKeyValue(const s:string;var key,value:string);
var
 epos:integer;
begin
 try
 epos:=pos('=',s);
 value:=copy(s,epos+1,length(s));
 key:=copy(s,0,epos-1);
 except
  Exception.create('Error in splitKeyvalue')
 end
end;

{ TIniFile }
constructor TIniFile.Create(const AFileName: string);
begin
 FFileName:=AFilename;
 FContent:=TStringList.create;
 if FileExists(AFileName) then
  FContent.LoadFromFile(AFileName);
end;

destructor TIniFile.Destroy;
begin
  inherited;
  FContent.Free;
end;

procedure TIniFile.ReadSectionValues(const Section: string;
  Strings: TStrings);
var
 i:integer;
 Inside:boolean;
begin
 Inside:=false;
 for i:=0 to FContent.count-1 do
  if trim(FContent[i])='['+Section+']' then
    Inside:=true
  else  if (Copy(trim(FContent[i]),0,1)='[') and inside then
    exit
  else if (inside) and (FContent[i]<>'') then
    Strings.Add(trim(FContent[i]));
end;

function TIniFile.ReadString(const Section, Ident,
  Default: string): string;
var
 i:integer;
 inside:boolean;
 key,value:string;
begin
 Inside:=false;
 for i:=0 to FContent.count-1 do
  if trim(FContent[i])='['+Section+']' then
    Inside:=true
  else  if (Copy(trim(FContent[i]),0,1)='[') and inside then
    exit
  else if inside then begin
    SplitKeyValue(trim(FContent[i]),key,value);
    if CompareText(key,ident)=0 then begin
      Result:=Value;
      break;
    end
  end;
end;

procedure TIniFile.EraseSection(const Section: string);
var
 i:integer;
 inside:boolean;
begin
 i:=0;
 inside:=false;
 repeat
  if (trim(FContent[i])='['+Section+']') and not(inside) then
    Inside:=true
  else if (trim(FContent[i])='['+Section+']') and inside then begin
    FContent.delete(i);
    i:=FCOntent.count-1;
  end
  else  if (Copy(trim(FContent[i]),0,1)='[') and inside then begin
    FContent.delete(i-1);
    i:=FCOntent.count-1;
  end
  else if inside then begin
    FContent.delete(i);
    dec(i);
  end;
  inc(i);
 until
   (i=FCOntent.count);
end;

procedure TIniFile.SaveSectionValues(const Section: string;
  Strings: TStrings);
var
 i:integer;
 s1,s2:string;
begin
 EraseSection(Section);
 for i:=0 to Strings.count-1 do begin
  SplitKeyValue(Strings[i],s1,s2);
  WriteString(Section,s1,s2);
 end;
end;

procedure TIniFile.UpdateFile;
begin
    FCOntent.SaveToFIle(FFilename)
end;

procedure TIniFile.WriteString(const Section, Ident, Value: String);
var
 i:integer;
 inside:boolean;
 key,avalue:string;
begin
 if ident='' then exit;
 Inside:=false;
 for i:=0 to FContent.count-1 do
  //Section Existe
  if trim(FContent[i])='['+Section+']' then
    Inside:=true
   //Donnes n'existaient pas -> insres
  else  if (Copy(trim(FContent[i]),0,1)='[') and inside then begin
    FContent.Insert(i,ident+'='+value) ;
    exit;
  end
  else if inside then begin
   //Section et donnes existaient -> valeur remplace
    SplitKeyValue(trim(FContent[i]),key,avalue);
    if CompareText(key,ident)=0 then begin
      FContent[i]:=ident+'='+value;
      exit;
    end
  end;
  //Section n'existait pas -> ajoutes
  if not inside then
    FContent.Add('['+section+']');
  //Donnes n'existait pas + fin de fichier -> ajoutes
  FContent.Add(ident+'='+value);
end;

function resolveRelativeUriStr(const baseUri,
                                     relUri: string;
                                 var resultUri: string): boolean;
var
  BaseUriAnalyzer,RelUriAnalyzer: TUriStrAnalyzer;
  i,slashPos,queryIndex: integer;
  pathBuffer: string;
  segments: TStringList;
begin
  resultUri:= '';
  BaseUriAnalyzer:= TUriStrAnalyzer.create;
  RelUriAnalyzer:= TUriStrAnalyzer.create;
  try
    result:= BaseUriAnalyzer.setUriReference(baseUri);
    result:= (RelUriAnalyzer.setUriReference(relUri) and result);
    result:= ((BaseUriAnalyzer.HasUriScheme or RelUriAnalyzer.HasUriScheme) and result);
    if not result then exit;  // baseUri is not an absolute URI reference, or baseUri or relUri is maleformed
    with RelUriAnalyzer do begin
      if (UriPath = '') and not ( HasUriScheme or HasUriAuthority or HasUriQuery) then begin
        // Same document reference detected
        BaseUriAnalyzer.setUriFragment(UriFragment,HasUriFragment);
        resultUri:= BaseUriAnalyzer.UriReference;
        exit;
      end;
      if HasUriScheme then begin
        // relUri is an absolute URI --> we are done.
        resultUri:= relUri;
        exit;
      end;
      // inherit scheme:
      setUriScheme(BaseUriAnalyzer.UriScheme,BaseUriAnalyzer.HasUriScheme);
      if not HasUriAuthority then begin
        // inherit authority:
        setUriAuthority(BaseUriAnalyzer.UriAuthority,BaseUriAnalyzer.HasUriAuthority);
        if not (copy(UriPath,1,1) = '/') then begin
          // analyze paths:
          segments:= TStringList.create;
          try
            slashPos:= LastDelimiter('/',BaseUriAnalyzer.UriPath);
            if slashPos > 0
              then pathBuffer:= copy(BaseUriAnalyzer.UriPath,2,slashPos-1) // Copy path without last segment and first character which is always '/'
              else pathBuffer:= '';
            pathBuffer:= concat(pathBuffer,UriPath);
            with segments do begin
              // cut pathBuffer into segments:
              slashPos:= pos('/',pathBuffer);
              while slashPos > 0 do begin
                Add(copy(pathBuffer,1,slashPos-1));
                pathBuffer:= copy(pathBuffer,slashPos+1,length(pathBuffer)-slashPos);
                slashPos:= pos('/',pathBuffer);
              end; {while ...}
              Add(pathBuffer);
              if (pathBuffer = '..') or (pathBuffer = '.')
                then Add(''); // Necessary to preserve ending '/' under some circumstances
              // remove '.' segments:
              queryIndex:= IndexOf('.');
              while queryIndex > -1 do begin
                delete(queryIndex);
                queryIndex:= IndexOf('.');
              end;
              // remove '<segment>/..' segments:
              queryIndex:= IndexOf('..');
              while queryIndex > 0 do begin
                delete(queryIndex);
                delete(pred(queryIndex));
                queryIndex:= IndexOf('..');
              end;
              // test for maleformed path:
              if count > 0
                then if strings[0] = '..' then begin
                  result:= false;
                  exit;
                end;
              pathBuffer:= '';
              for i:= 0 to pred(count) do
                pathBuffer:= concat(pathBuffer,'/',strings[i]);
              setUriPath(pathBuffer);
            end; {with segments ...}
          finally
            segments.free;
          end;
        end; {if not (copy(UriPath,1,1) = '/') ...}
      end; {if not HasAuthorityScheme ...}
      resultUri:= UriReference;
    end; {with RelUriAnalyzer ...}
  finally
    BaseUriAnalyzer.free;
    RelUriAnalyzer.free;
  end;
end;

constructor TUriStrAnalyzer.create;
begin
  setUriReference('');
end;

function TUriStrAnalyzer.getUriReference: string;
begin
  result:= '';
  if FHasUriScheme
    then result:= concat(result,FUriScheme,':');
  if FHasUriAuthority
    then result:= concat(result,'//',FUriAuthority);
  result:= concat(result,FUriPath);
  if FHasUriQuery
    then result:= concat(result,'?',FUriQuery);
  if FHasUriFragment
    then result:= concat(result,'#',FUriFragment);
end;

function TUriStrAnalyzer.setUriAuthority(const Value: string;
                                         const isDefined: boolean): boolean;
begin
  result:= true;
  FHasUriAuthority:= isDefined;
  if isDefined then begin
    if isUriAuthorityStr(Value)
      then FUriAuthority:= value
      else begin FUriAuthority:= ''; result:= false; end;
  end else FUriAuthority:= '';
end;

function TUriStrAnalyzer.setUriFragment(const Value: string;
                                        const isDefined: boolean): boolean;
begin
  result:= true;
  FHasUriFragment:= isDefined;
  if isDefined then begin
    if isUriFragmentStr(Value)
      then FUriFragment:= value
      else begin FUriFragment:= ''; result:= false; end;
  end else FUriFragment:= '';
end;

function TUriStrAnalyzer.setUriPath(const Value: string): boolean;
begin
  result:= isUriPathStr(Value);
  if result
    then FUriPath:= value
    else FUriPath:= '';
end;

function TUriStrAnalyzer.setUriQuery(const Value: string;
                                     const isDefined: boolean): boolean;
begin
  result:= true;
  FHasUriQuery:= isDefined;
  if isDefined then begin
    if isUriQueryStr(Value)
      then FUriQuery:= value
      else begin FUriQuery:= ''; result:= false; end;
  end else FUriQuery:= '';
end;

function TUriStrAnalyzer.setUriReference(const Value: string): boolean;
var
  colonPos,dcPos,qmPos,slashPos: integer;
  s: string;
begin
  colonPos:= pos(':',value);
  result:= setUriScheme(copy(value,1,colonPos-1),(colonPos > 0));
  s:= copy(value,colonPos+1,length(value)-colonPos);

  dcPos:= pos('#',s);
  if dcPos > 0 then begin
    result:= (setUriFragment(copy(s,dcPos+1,length(s)-dcPos),true) and result);
    s:= copy(s,1,dcPos-1);
  end else setUriFragment('',false);

  qmPos:= pos('?',s);
  if qmPos > 0 then begin
    result:= (setUriQuery(copy(s,qmPos+1,length(s)-qmPos),true) and result);
    s:= copy(s,1,qmPos-1);
  end else setUriQuery('',false);

  if copy(s,1,2) = '//' then begin
    s:= copy(s,3,length(s)-2);
    slashPos:= pos('/',s);
    if slashPos > 0 then begin
      result:= (setUriAuthority(copy(s,1,slashPos-1),true) and result);
      s:= copy(s,slashPos,length(s)-slashPos+1);
    end else begin
      result:= (setUriAuthority(s,true) and result);
      s:= '';
    end;
  end else setUriAuthority('',false);

  result:= setUriPath(s) and result;

  if not result then setUriReference('');
end;

function TUriStrAnalyzer.setUriScheme(const Value: string;
                                      const isDefined: boolean): boolean;
begin
  result:= true;
  FHasUriScheme:= isDefined;
  if isDefined then begin
    if isUriSchemeStr(Value)
      then FUriScheme:= value
      else begin FUriScheme:= ''; result:= false; end;
  end else FUriScheme:= '';
end;

function isAbnfALPHAChar(c: char): boolean;
begin
  case byte(c) of
    $41..$5A,$61..$7A:
    result:= true;
  else
    result:= false;
  end;
end;

function isAbnfBITChar(c: char): boolean;
begin
  if (c = '0') or (c = '1')
    then result:= true
    else result:= false;
end;

function isAbnfCHARChar(c: char): boolean;
begin
  case byte(c) of
    $01..$7F:
    result:= true;
  else
    result:= false;
  end;
end;

function isAbnfCRChar(c: char): boolean;
begin
  if c = #$0D
    then result:= true
    else result:= false;
end;

function isAbnfCRLFStr(s: string): boolean;
begin
  if s = #$0D#$0A
    then result:= true
    else result:= false;
end;

function isAbnfCTLChar(c: char): boolean;
begin
  case byte(c) of
    $00..$1F,$7F:
    result:= true;
  else
    result:= false;
  end;
end;

function isAbnfDIGITChar(c: char): boolean;
begin
  case byte(c) of
    $30..$39:
    result:= true;
  else
    result:= false;
  end;
end;

function isAbnfDQUOTEChar(c: char): boolean;
begin
  if c = #$22
    then result:= true
    else result:= false;
end;

function isAbnfHEXDIGChar(c: char): boolean;
begin
  case byte(c) of
    $30..$39,$41..$46:
    result:= true;
  else
    result:= false;
  end;
end;

function isAbnfHTABChar(c: char): boolean;
begin
  if c = #$09
    then result:= true
    else result:= false;
end;

function isAbnfLFChar(c: char): boolean;
begin
  if c = #$0A
    then result:= true
    else result:= false;
end;

function isAbnfLWSPStr(s: string): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  if l = 0
    then begin result:= false; exit; end
    else result:= true;
  i:= 0;
  while i < l do begin
    inc(i);
    case byte(s[i]) of
      $20,$09:; // SP or TAB --> Do nothing, because everthing is alright
      $0D: begin  // CR --> Look for LF
        if i = l then begin result:= false; exit; end;
        inc(i);
        if s[i] <> #$0A then begin result:= false; exit; end;
      end;
    else begin
      result:= false;
      exit;
      end;
    end;
  end;
end;

function isAbnfOCTETChar(c: char): boolean;
begin
  case byte(c) of
    $00..$ff:
    result:= true;
  else
    result:= false;
  end;
end;

function isAbnfSPChar(c: char): boolean;
begin
  if c = #$20
    then result:= true
    else result:= false;
end;

function isAbnfVCHARChar(c: char): boolean;
begin
  case byte(c) of
    $21..$7E:
    result:= true;
  else
    result:= false;
  end;
end;

function isAbnfWSPChar(c: char): boolean;
begin
  case byte(c) of
    $20,$09:
    result:= true;
  else
    result:= false;
  end;
end;

function UriStrToFilename(const uri: string;
                            var path: TFilename;
                            var authority,
                                query,
                                fragment: string): boolean;
var
  UriAnalyzer: TUriStrAnalyzer;
  pathBuffer: string;  // Used to increase performance
  i,l: integer;
begin
  path:= '';
  query:= '';
  fragment:= '';
  result:= false;
  UriAnalyzer:= TUriStrAnalyzer.create;
  try
    with UriAnalyzer do begin
      if setUriReference(uri) then begin
        if CompareText(UriScheme,'file') = 0 then begin
          result:= true;
          pathBuffer:= UriPath;
          l:= length(pathBuffer);
          if l > 0 then begin
            // remove leading '/':
            dec(l);
            pathBuffer:= copy(pathBuffer,2,l);
            i:= 1;
            while i <= l do begin
              if pathBuffer[i] = '%' then begin
                // resolve escape sequence:
                path:= concat(path,chr(StrToInt(concat('x',pathBuffer[i+1],pathBuffer[i+2]))));
                i:= i+2;
              end else if pathBuffer[i] = '/' then begin
                // translate '/' to '\':
                path:= concat(path,'\');
              end else path:= concat(path,pathBuffer[i]);
              inc(i);
            end; {while ...}
          end; {if ...}
          authority:= UriAuthority;
          if HasUriQuery
            then query:= concat('?',UriQuery);
          if HasUriFragment
            then fragment:= concat('#',UriFragment);
        end; {if ...}
      end; {if ...}
    end; {with ...}
  finally
    UriAnalyzer.free;
  end;
end;


function TranslateChar(const Str: string; FromChar, ToChar: Char): string;
var
  I: Integer;
begin
  Result := Str;
  for I := 1 to Length(Result) do
    if Result[I] = FromChar then
      Result[I] := ToChar;
end;

function UnixPathToDosPath(const Path: string): string;
begin
  Result := TranslateChar(Path, '/', '\');
end;

function DosPathToUnixPath(const Path: string): string;
begin
  Result := TranslateChar(Path, '\', '/');
end;


procedure StringFromFile(const fname:string;var s:string);
var
 fs:TFileStream;
begin
 try
 fs:=TFileStream.Create(fname,fmOpenRead);
 SetLength(s,fs.size);
 fs.ReadBuffer(Pointer(s)^,fs.size);
 finally
  if Assigned(fs) then
   fs.free;
 end;
end;




end.
